 ; Ŀ
 ;   Cable - insert a cdf file into a cable schedule.                      
 ;   Copyright 2001, 2002 by Rocket Software Ltd.                          
 ;   Assumes that the fields in the cdf file are in the same order as      
 ;   the attributes in the block, and that there are no extraneous commas  
 ;   and no double quotes.  In other words that things were done right.    
 ;                                                                         
 ;   Playing horseshoes with a crown is not actually the sport of kings.   
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Cable.                                                                
 ; 
 (DEFUN C:CABLE (/ ss fn num subnum pa linn llist dwgno revno dwgttl chra
                                                                namm gnunam)
  (setvar "cmdecho" 0)
  (setvar "attreq" 1)
  (setvar "attdia" 0)
  (setvar "limcheck" 0)
  (if (setq ss (ssget "X" (list (cons 2 "cable"))))
      (command ".erase" ss ""))
  (if (and (setq filnam (getfiled "Data File" "Cables.cdf" "" 0))
           (setq fn (open filnam "r")))
      (progn
           (setq num 0)
           (setq subnum 0)
           (setq pa (list 20 516))
           (while (setq linn (read-line fn))
                  (setq llist (csplit (strcase linn)))
                  (command ".insert" "cable" pa "" "" "")
                  (while (and (setq nexstr (car llist))
                              (= 1 (getvar "cmdactive")))
                         (setq llist (cdr llist))
                         (command nexstr))
                  (while (= 1 (getvar "cmdactive"))
                         (command ""))
                  (setq num (1+ num))
                  (setq subnum (1+ subnum))
                  (if (= subnum 4)
                      (progn
                           (setq pa (polar pa (* pi 1.5) 6))
                           (setq subnum 0)))
                  (if (= num 56)
                      (progn
                           (setq pa (list 20 516))
                           (setq subnum 0)
                           (setq num 0)
                           (setq namm (getvar "dwgname"))
                           (setq pref (getvar "dwgprefix"))
                           (if (null chra)
                               (setq chra "A")
                               (setq chra (chr (1+ (ascii chra)))))
                           (setq namm (strcat pref namm chra))
                           (setq gnunam (getstring (strcat "Second page name <"
                                                            namm ">: ")))
                           (if (= gnunam "") (setq gnunam namm))
                           (command ".qsave")
                           (command ".saveas" "" gnunam)
                           (setq ss (ssget "X" (list (cons 2 "cable"))))
                           (command ".erase" ss ""))
                      (setq pa (polar pa (* pi 1.5) 6))))
           (close fn)))
 (princ))